import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define colors for statuses
colors = {'clear': 'green', 'supporting': 'red', 'not clear': 'red'}

# Define block positions and sizes
block_width, block_height = 1, 0.5
table_height = 0.3
hand_radius = 0.25

# Draw the table
table = patches.Rectangle((0, 0), 6, table_height, linewidth=1, edgecolor='black', facecolor='lightgray')
ax.add_patch(table)

# Draw the blocks
blocks = {
    'b': (2, table_height, 'clear'),  # on table
    'd': (4, table_height, 'supporting'),  # on table
    'a': (4, table_height + block_height, 'clear')  # on block d
}

for block, (x, y, status) in blocks.items():
    rect = patches.Rectangle((x, y), block_width, block_height, linewidth=1,
                             edgecolor='black', facecolor=colors[status])
    ax.add_patch(rect)
    ax.text(x + block_width / 2, y + block_height / 2, f'{block}\n{status}',
            horizontalalignment='center', verticalalignment='center', fontsize=9, color='white')

# Draw the hand holding block c
hand_x, hand_y = 6, table_height + 4 * block_height + hand_radius * 2
hand = patches.Circle((hand_x, hand_y), hand_radius, linewidth=1, edgecolor='black', facecolor='blue')
ax.add_patch(hand)
ax.text(hand_x, hand_y, 'hand\nholding c',
        horizontalalignment='center', verticalalignment='center', fontsize=9, color='white')

# Draw block c in hand
block_c_x, block_c_y = hand_x - block_width / 2, hand_y - block_height / 2
block_c = patches.Rectangle((block_c_x, block_c_y), block_width, block_height, linewidth=1,
                            edgecolor='black', facecolor=colors['not clear'])
ax.add_patch(block_c)
ax.text(block_c_x + block_width / 2, block_c_y + block_height / 2, 'c\nnot clear',
        horizontalalignment='center', verticalalignment='center', fontsize=9, color='white')

# Create a legend
legend_patches = [
    patches.Patch(color='green', label='Clear'),
    patches.Patch(color='red', label='Supporting')
]
plt.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and aspect
ax.set_xlim(-1, 7)
ax.set_ylim(-0.5, 5)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()